#pragma once

#define LITEHTML_USE_BIDI

#define ALLOC_STRATEGIE_FEATSTD 1
#define ALLOC_STRATEGIE_STD 2
#define ALLOC_STRATEGIE_OBJECTPOOL 3

#define ALLOC_STRATEGIE ALLOC_STRATEGIE_FEATSTD

#if ALLOC_STRATEGIE == ALLOC_STRATEGIE_FEATSTD
    #include <FeatStd/MemoryManagement/Heap.h>
    #if defined(FEATSTD_MEMORYPOOL_ENABLED)
        extern bool InitLiteHtmlMemoryPool();
        FEATSTD_MEMORYPOOL_DEFINE_MANAGED_MEMORYPOOL(LiteHtmlMemoryPool, InitLiteHtmlMemoryPool);

        #define LITEHTML_NEW(type) FEATSTD_MEMORYPOOL_TRANSIENT_NEW(LiteHtmlMemoryPool, type)
        #define LITEHTML_DELETE(obj) FEATSTD_MEMORYPOOL_DELETE(obj)
        #define LITEHTML_ALLOC(size) FEATSTD_MEMORYPOOL_TRANSIENT_ALLOC(LiteHtmlMemoryPool, size)
        #define LITEHTML_FREE(ptr) FEATSTD_MEMORYPOOL_FREE(LiteHtmlMemoryPool, ptr)
    #else
        #define LITEHTML_NEW(type) FEATSTD_NEW(type)
        #define LITEHTML_DELETE(obj) FEATSTD_DELETE(obj)
        #define LITEHTML_ALLOC(size) FEATSTD_ALLOC(size)
        #define LITEHTML_FREE(ptr) FEATSTD_FREE(ptr)
    #endif
#elif ALLOC_STRATEGIE == ALLOC_STRATEGIE_STD
    #include <stdlib.h>

    #define LITEHTML_NEW(type) new type
    #define LITEHTML_DELETE(obj) delete obj
    #define LITEHTML_ALLOC(size) malloc(size)
    #define LITEHTML_FREE(ptr) free(ptr)
#elif ALLOC_STRATEGIE == ALLOC_STRATEGIE_OBJECTPOOL
    #include <FeatStd/Platform/Types.h>

    namespace LiteHtmlObjectPool {

        struct PlacementNewType {
        };

        class Pool {
            public:
                Pool() : m_index(0) {}

                void* Alloc(FeatStd::SizeType nBytes)
                {
                    void* p = &m_memory[m_index];
                    m_index += (nBytes + 3) & 0xFFFFFFFC;
                    return p;
                }

            private:
                char m_memory[50000000];
                int m_index;

        };

        extern Pool s_pool;

        template<typename T>
        static inline void* Alloc(/*const char* file, int line*/)
        {
            return s_pool.Alloc(sizeof(T));
        }

        static inline void* PlainAlloc(size_t nBytes/*, const char* file, int line*/)
        {
            return s_pool.Alloc(nBytes);
        }

        template<typename T>
        static inline void Destroy(T *object)
        {
            if (object != 0) {
                object->~T();

                // current implementation (just for test purpose) does not need to free the memory
            }
        }
    };

    inline
    void* operator new(size_t, LiteHtmlObjectPool::PlacementNewType* p)
    {
        return p;
    }

    inline void operator delete(void*, LiteHtmlObjectPool::PlacementNewType* )
    {
    }


    #define LITEHTML_NEW(type) \
        new(LiteHtmlObjectPool::Alloc<type>(/*__FILE__, __LINE__*/)) type

    #define LITEHTML_DELETE(objectPtr) \
        LiteHtmlObjectPool::Destroy(objectPtr)

    #define LITEHTML_ALLOC(nBytes) \
        LiteHtmlObjectPool::PlainAlloc(nBytes/*, __FILE__, __LINE__*/)

    #define LITEHTML_FREE(ptr)
#else
    #error "ALLOC_STRATEGIE not defined!"
#endif

#define LITEHTML_UTF8

class DummyCriticalSection {
    public:
        DummyCriticalSection() {}

        void Obtain() {}
        void Release() {}
};

#define REF_CS DummyCriticalSection

class DummyLocker {
    public:
        DummyLocker(REF_CS*) { }

        void Release() {}
};

#define REF_CS_SCOPE DummyLocker

//#include <FeatStd/Platform/CriticalSectionLocker.h>
//#define REF_CS FeatStd::Internal::CriticalSection
//#define REF_CS_SCOPE FeatStd::Internal::CriticalSectionLocker

#include <litehtml/Ref/Ref.h>
#include <litehtml/Ref/WeakRef.h>
